import copy


def geom_norm(A, B):
    nA = copy.deepcopy(A)
    nB = copy.deepcopy(B)
    col_sum = A.sum(axis=0)
    row_sum = B.sum(axis=1)
    dim = len(A[0])
    for d in range(dim):
        if col_sum[d] == 0 or row_sum[d] == 0:
            for i in range(len(A)):
                nA[i][d] = 0
            for i in range(len(B[0])):
                nB[d][i] = 0
        else:
            for i in range(len(A)):
                nA[i][d] *= (row_sum[d] / col_sum[d]) ** 0.5
            for i in range(len(B[0])):
                nB[d][i] *= (col_sum[d] / row_sum[d]) ** 0.5
    return nA, nB
